<?php
include ('./includes/header.php');

// Conectar-se ao banco de dados SQLite
$db = new SQLite3('./api/db/studiolivecode_clientes.db');

// Consulta para contar o número de registros na tabela "ibo" onde "active" é 0
$res_ibo_inactive = $db->query('SELECT COUNT(*) AS total_inactive_users FROM ibo WHERE active = 0');
$row_ibo_inactive = $res_ibo_inactive->fetchArray();

// Verificar se a consulta retornou com sucesso
if ($row_ibo_inactive) {
    // Recuperar o número total de usuários inativos da consulta
    $total_inactive_users_ibo = $row_ibo_inactive['total_inactive_users'];
} else {
    // Se ocorrer um erro ao executar a consulta, defina o número total de usuários inativos como 0
    $total_inactive_users_ibo = 0;
}

// Consulta para contar o número de registros na tabela "ibo" onde "active" é 1
$res_ibo_active = $db->query('SELECT COUNT(*) AS total_active_users FROM ibo WHERE active = 1');
$row_ibo_active = $res_ibo_active->fetchArray();

// Verificar se a consulta retornou com sucesso
if ($row_ibo_active) {
    // Recuperar o número total de usuários ativos da consulta
    $total_active_users_ibo = $row_ibo_active['total_active_users'];
} else {
    // Se ocorrer um erro ao executar a consulta, defina o número total de usuários ativos como 0
    $total_active_users_ibo = 0;
}

// Consulta para contar o número total de registros na tabela "ibo"
$res_ibo_total = $db->query('SELECT COUNT(*) AS total_users FROM ibo');
$row_ibo_total = $res_ibo_total->fetchArray();

// Verificar se a consulta retornou com sucesso
if ($row_ibo_total) {
    // Recuperar o número total de usuários da consulta
    $total_users_ibo = $row_ibo_total['total_users'];
} else {
    // Se ocorrer um erro ao executar a consulta, defina o número total de usuários como 0
    $total_users_ibo = 0;
}
?>

<div class="content-page">
    <div class="content">
        <!-- Start Content-->
        <div class="container-fluid">
            <div class="row card-container-123">
                <div class="col-xl-4 col-lg-6 card-box-123">
                    <div class="card-123">
                        <div class="card-body-123">
                            <div class="row align-items-center">
                                <div class="col-12">
                                    <img class="ms-3" src="assets/images/8943377.png" width="92" alt="Generic placeholder image">
                                    <h5 class="text-uppercase fs-13 mt-0 text-truncate" title="Active Users">Testes ChatBot</h5>
                                    <h2 class="my-2 py-1" id=""><?php echo $total_inactive_users_ibo; ?></h2>
                                    <p class="mb-0 text-muted text-truncate">
                                        <span class="text-success me-2"><i class="ri-arrow-up-line"></i> Clientes</span>
                                        <span class="text-nowrap">Criados com ChatBot</span>
                                    </p>
                                </div>
                            </div><!-- end row-->
                        </div><!-- end card-body -->
                    </div><!-- end card -->
                </div>

                <div class="col-xl-4 col-lg-6 card-box-123">
                    <div class="card-123">
                        <div class="card-body-123">
                            <div class="row align-items-center">
                                <div class="col-12">
                                    <img class="ms-3" src="assets/images/6073874.png" width="92" alt="Generic placeholder image">
                                    <h5 class="text-uppercase fs-13 mt-0 text-truncate" title="Active Users">Clientes Ativos</h5>
                                    <h2 class="my-2 py-1" id=""><?php echo $total_active_users_ibo; ?></h2>
                                    <p class="mb-0 text-muted text-truncate">
                                        <span class="text-success me-2"><i class="ri-arrow-up-line"></i> Clientes</span>
                                        <span class="text-nowrap">adicionado manualmente</span>
                                    </p>
                                </div>
                            </div><!-- end row-->
                        </div><!-- end card-body -->
                    </div><!-- end card -->
                </div>

                <div class="col-xl-4 col-lg-6 card-box-123">
                    <div class="card-123">
                        <div class="card-body-123">
                            <div class="row align-items-center">
                                <div class="col-12">
                                    <img class="ms-3" src="assets/images/9255685.png" width="92" alt="Generic placeholder image">
                                    <h5 class="text-uppercase fs-13 mt-0 text-truncate" title="Active Users">Todos Clientes</h5>
                                    <h2 class="my-2 py-1" id=""><?php echo $total_users_ibo; ?></h2>
                                    <p class="mb-0 text-muted text-truncate">
                                        <span class="text-success me-2"><i class="ri-arrow-up-line"></i> Clientes</span>
                                        <span class="text-nowrap">totais no painel</span>
                                    </p>
                                </div>
                            </div><!-- end row-->
                        </div><!-- end card-body -->
                    </div><!-- end card -->
                </div>
            </div>



<!-- Daterangepicker js -->
<script src="./assets/vendor/daterangepicker/moment.min.js"></script>
<script src="./assets/vendor/daterangepicker/daterangepicker.js"></script>

<!-- Charts js -->
<script src="./assets/vendor/chart.js/chart.min.js"></script>
<script src="./assets/vendor/apexcharts/apexcharts.min.js"></script>

<!-- Vector Map js -->
<script src="./assets/vendor/admin-resources/jquery.vectormap/jquery-jvectormap-1.2.2.min.js"></script>
<script src="./assets/vendor/admin-resources/jquery.vectormap/maps/jquery-jvectormap-world-mill-en.js"></script>

<!-- Analytics Dashboard App js -->
<script src="./assets/js/pages/demo.dashboard-analytics.js"></script>

<!-- App js -->
<script src="./assets/js/app.min.js"></script>

<?php include ('./includes/footer.php'); ?>